﻿' ----------------------------------------------------------------------------
' initializes the GUI
' ----------------------------------------------------------------------------
Function InitGUI()

	' Application Title
	AppTitle = title + " " + version
	
	' Create a new windows using MAXGUI gadgets
	Window = CreateWindow (title + " " + version, ClientWidth(Desktop()) / 2 - (width / 2), ClientHeight(Desktop()) / 2 - (Height / 2), width + 24, Height + 110, Null, WINDOW_TITLEBAR | WINDOW_RESIZABLE | WINDOW_MENU | WINDOW_STATUS)
	SetPanelColor(Window, 0, 0, 0)
	OldWindowFunc = SetWindowFunc(Window, WindowFunc)
	
	' ----------------------------------------------------------------------------
	' Tabs
	' ----------------------------------------------------------------------------
	
	' create tabs
	tabs = CreateTabber(0, 0, ClientWidth(Window), ClientHeight(Window), Window)
	SetGadgetIconStrip(tabs, icons)
	AddGadgetItem(tabs, "Monitor", False, 12, "")
	AddGadgetItem(tabs, "Statistics", False, 11, "")
	AddGadgetItem(tabs, "Analysis", False, 13, "")
	AddGadgetItem(tabs, "Debuglog", False, 10, "")
	
	' create Documents in Tabs
	tab[0] = CreateDocument(tabs)
	tab[1] = CreateDocument(tabs)
	tab[2] = CreateDocument(tabs)
	tab[3] = CreateDocument(tabs)
	SetPanelColor tab[0], 0, 0, 0
	SetPanelColor tab[1], 0, 0, 0
	SetPanelColor tab[2], 0, 0, 0
	SetPanelColor tab[3], 0, 0, 0
	'currenttab = tab[0]
	'ShowGadget currenttab
	'HideGadget currenttab
	currenttab = tab[tabsflag]
	ShowGadget currenttab
	SelectGadgetItem(tabs, tabsflag)
	
	
	' ----------------------------------------------------------------------------
	' Documents in Tabs
	' ----------------------------------------------------------------------------
	
	' Create a canvas (main window)
	canvas = CreateCanvas(0, 0, width, Height, tab[0], 0)
	
	' Create a canvas for statistics
	statistics = CreateCanvas(0, 0, width, Height, tab[1], 0)
			
	' Create a canvas for analysis
	analysis = CreateCanvas(0, 0, width, Height, tab[2], 0)
	
	' set canvas buffer
	SetGraphics CanvasGraphics(analysis)
		
	' Add clickable Calendar 1 (left) month selection buttons
	click.Add(canvas, "CAL1BACK", "", cal1, width - 390 + 8, Height - 350 + 10, 20, 18)
	click.Add(canvas, "CAL1FORWARD", "", cal1, width - 234 + 8, Height - 350 + 10, 20, 18)

	' Add clickable Calendar 2 (right) month selection buttons
	click.Add(canvas, "CAL2BACK", "", cal2, width - 200 + 8, Height - 350 + 10, 20, 18)
	click.Add(canvas, "CAL2FORWARD", "", cal2, width - 44 + 8, Height - 350 + 10, 20, 18)
	
	' Add clickable Calendar Day Buttons (left+right)
	For Local x:Int = 0 To 6
	
		For Local y:Int = 0 To 5
		
			click.Add(canvas, "CAL1_" + ((y * 7) + x), ((y * 7) + x), cal1, width - 377 + (x * 24), Height - 295 + (y * 16), 21, 16)
			click.Add(canvas, "CAL2_" + ((y * 7) + x), ((y * 7) + x), cal2, width - 187 + (x * 24), Height - 295 + (y * 16), 21, 16)
		
		Next
		
	Next	
			
	' Debug Log
	LogDebug = CreateTextArea(0, 0, width, Height, tab[3], TEXTAREA_WORDWRAP | TEXTAREA_READONLY)
	Local guifont:TGuiFont = LookupGuiFont(GUIFONT_SYSTEM, 12)
	SetGadgetFont(LogDebug, guifont)
	SetTextAreaColor(LogDebug, 0, 0, 0, True)
	SetTextAreaColor(LogDebug, 0, 255, 0, False)

	' set layout and activation
	SetGadgetLayout Window, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED
	SetGadgetLayout canvas, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED
	SetGadgetLayout statistics, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED
	SetGadgetLayout LogDebug, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED, EDGE_ALIGNED
	SetGraphics CanvasGraphics(statistics)
	
	progress = CreateProgBar(width / 2 - 100, Height - 60, 200, 10, canvas)

	
	' ----------------------------------------------------------------------------
	' Menus
	' ----------------------------------------------------------------------------
	
	' create File menu
	filemenu = CreateMenu("File", 0, WindowMenu(Window))
	AddMenu("Select Journal Folder", filemenu, MENU_BROWSE, 0, icons, Null, False)
	AddMenu("Export Scan data to SQLite database", filemenu, MENU_EXPORT, 7, icons, Null, False)
	AddMenu("Load CMDR Database Export", filemenu, MENU_IMPORT, 14, icons, Null, False)
	AddMenu("Save Statistics Screenshot", filemenu, MENU_SCREENSHOT, 6, icons, Null, False)
	AddMenu("Save Settings", filemenu, MENU_SAVE, 2, icons, Null, False)
	AddMenu("Exit", filemenu, MENU_EXIT, 1, icons, Null, False)
	
	' create Scan Menu
	scanmenu = CreateMenu("Scanning", 0, WindowMenu(Window))

	' create Scan Menu
	optionsmenu = CreateMenu("Options", 0, WindowMenu(Window))
	ontopmenu = AddMenu("Always on top", optionsmenu, MENU_ONTOP, 5, icons, Null, True)
	AddMenu("Compact Mode", optionsmenu, MENU_COMPACTMODE, 8, icons, Null, True)
	AddMenu("Full Mode", optionsmenu, MENU_FULLMODE, 9, icons, Null, True)
	configmenu = AddMenu("Save Settings on Exit", optionsmenu, MENU_SAVEEXIT, 10, icons, Null, False)
	
	' create About Menu
	aboutmenu = CreateMenu("About", 0, WindowMenu(Window))
	AddMenu("Info", aboutmenu, MENU_ABOUT, 4, icons, Null, False)
	
	' ----------------------------------------------------------------------------
	' Volume Slider
	' ----------------------------------------------------------------------------
			
	' create volume slider
	volume = CreateSlider(width / 2 - 65, Height - 32, 130, 32, canvas, SLIDER_HORIZONTAL | SLIDER_TRACKBAR)
	SetSliderRange(volume, 1, 100)
	SetSliderValue(volume, channelvolume)
		
	' ----------------------------------------------------------------------------
	' Buttons
	' ----------------------------------------------------------------------------
	
	' Quick Scan Buttons
	statbutton1 = CreateButton("Scan", width - 390, Height - 185, 190, 26, canvas, BUTTON_PUSH)
	screenbutton = CreateButton("Screenshot", width - 94, 44, 90, 20, statistics, BUTTON_PUSH)
	statbutton2 = CreateButton("Scan", width - 94, 24, 90, 20, statistics, BUTTON_PUSH)

	' Time selector
	time = CreateComboBox(width - 198, Height - 184, 189, 28, canvas, Null)
	SetGadgetIconStrip(time, icons)
	
	For Local i:Int = 0 To timeline.Length - 1
	
		AddGadgetItem(time, timeline[i], 0, 3)
		timemenu[i] = AddMenu(timeline[i], scanmenu, MENU_SCAN + i, 3, icons, Null, False)
		
		if timerange=i then CheckMenu(timemenu[i])

	Next
		
	SelectGadgetItem(time, timerange)

	' first button column
	scanbutton = CreateButton("Scan Notice", width - 390, Height - 155, 128, 40, canvas, BUTTON_PUSH)
	scoobutton = CreateButton("Scoop Notice", width - 390, Height - 115, 128, 40, canvas, BUTTON_PUSH)
	warnbutton = CreateButton("Warnings", width - 390, Height - 75, 128, 40, canvas, BUTTON_PUSH)

	' second button column
	starbutton = CreateButton("Star Details", width - 263, Height - 155, 128, 40, canvas, BUTTON_PUSH)
	planbutton = CreateButton("Planet Details", width - 263, Height - 115, 128, 40, canvas, BUTTON_PUSH)
	precbutton = CreateButton("Precious Details", width - 263, Height - 75, 128, 40, canvas, BUTTON_PUSH)

	' third button column
	cashbutton = CreateButton("Cash Sounds", width - 136, Height - 155, 128, 40, canvas, BUTTON_PUSH)
	blipbutton = CreateButton("Blip Sounds", width - 136, Height - 115, 128, 40, canvas, BUTTON_PUSH)
	hornbutton = CreateButton("Horn Sounds", width - 136, Height - 75, 128, 40, canvas, BUTTON_PUSH)
	
	' Soundset selection
	sam1button = CreateButton("Limited Soundset", width - 390, Height - 34, 190, 30, canvas, BUTTON_PUSH)
	sam2button = CreateButton("Assistant Soundset", width - 198, Height - 34, 190, 30, canvas, BUTTON_PUSH)
	
	modebutton1 = CreateButton("Compact Mode", width - 94, 4, 90, 20, canvas, BUTTON_PUSH)
	modebutton2 = CreateButton("Compact Mode", width - 94, 4, 90, 20, statistics, BUTTON_PUSH)
	
	UpdateWindowMenu(window)
	
	' ----------------------------------------------------------------------------
	' Always on Top initialization
	' ----------------------------------------------------------------------------

	If ontop = 1 Then
	
		CheckMenu(ontopmenu)
		SetWindowTopMost(Window, True)
		
	Else
	
		UncheckMenu(ontopmenu)
		SetWindowTopMost(Window, False)
		
	EndIf
	
	calflag = 0
	If timelimit = -1 Then calflag = 1

	UpdateScale()
	UpdateGUI()
	
	'TBody.CreateDatabase()
	
End Function

' ----------------------------------------------------------------------------
' update GUI button colors
' ----------------------------------------------------------------------------
Function UpdateButtons()

	If scanflag Then SetGadgetColor(scanbutton, 0, 224, 0) Else SetGadgetColor(scanbutton, 224, 128, 128)
	If blipflag Then SetGadgetColor(blipbutton, 0, 224, 0) Else SetGadgetColor(blipbutton, 224, 128, 128)
	If scooflag Then SetGadgetColor(scoobutton, 0, 224, 0) Else SetGadgetColor(scoobutton, 224, 128, 128)
	If warnflag Then SetGadgetColor(warnbutton, 0, 224, 0) Else SetGadgetColor(warnbutton, 224, 128, 128)
	If starflag Then SetGadgetColor(starbutton, 0, 224, 0) Else SetGadgetColor(starbutton, 224, 128, 128)
	If planflag Then SetGadgetColor(planbutton, 0, 224, 0) Else SetGadgetColor(planbutton, 224, 128, 128)
	If cashflag Then SetGadgetColor(cashbutton, 0, 224, 0) Else SetGadgetColor(cashbutton, 224, 128, 128)
	If precflag Then SetGadgetColor(precbutton, 0, 224, 0) Else SetGadgetColor(precbutton, 224, 128, 128)
	If hornflag Then SetGadgetColor(hornbutton, 0, 224, 0) Else SetGadgetColor(hornbutton, 224, 128, 128)
	
	SetGadgetColor(sam1button, 224, 128, 128)
	SetGadgetColor(sam2button, 224, 128, 128)
	
	If sampflag = 0 Then SetGadgetColor(sam1button, 0, 224, 0)
	If sampflag = 1 Then SetGadgetColor(sam2button, 0, 224, 0)

End Function

' ----------------------------------------------------------------------------
' Window mode switch logic
' ----------------------------------------------------------------------------
Function ModeCheck()

	' compact mode
	If modeflag = 1 Then
	
		width = 384
		Height = 256
	
		SetMinWindowSize(Window, width, Height)
			
		' resize window, tabs and debuglog
		SetGadgetShape(Window, GadgetX(Window), GadgetY(Window), width + 24, Height + 110)
		SetGadgetShape(tabs, 0, 0, ClientWidth(Window), ClientHeight(Window))
		SetGadgetShape(LogDebug, 0, 0, ClientWidth(Window) - 4, ClientHeight(Window) - 24)
				
		' switch mode button
		FreeGadget(modebutton1)
		FreeGadget(modebutton2)
		FreeGadget(statbutton2)
		FreeGadget(screenbutton)
		modebutton1 = CreateButton("Full Mode", width - 94, 4, 90, 20, canvas, BUTTON_PUSH)
		modebutton2 = CreateButton("Full Mode", width - 94, 4, 90, 20, statistics, BUTTON_PUSH)
		screenbutton = CreateButton("Screenshot", width - 94, 24, 90, 20, statistics, BUTTON_PUSH)
		statbutton2 = CreateButton("Scan", width - 94, 44, 90, 20, statistics, BUTTON_PUSH)
		
		' hide buttons
		HideGadget statbutton1
		HideGadget scanbutton
		HideGadget blipbutton
		HideGadget scoobutton
		HideGadget warnbutton
		HideGadget starbutton
		HideGadget planbutton
		HideGadget cashbutton
		HideGadget precbutton
		HideGadget hornbutton
		HideGadget sam1button
		HideGadget sam2button
		HideGadget volume
		HideGadget time
		HideGadget progress
		
	Else
	
		width = 1024
		Height = 576
		
		SetMinWindowSize(Window, width, Height)
		
		' resize window, tabs and debuglog
		SetGadgetShape(Window, GadgetX(Window), GadgetY(Window), width + 24, Height + 110)
		SetGadgetShape(tabs, 0, 0, ClientWidth(Window), ClientHeight(Window))
		SetGadgetShape(LogDebug, 0, 0, ClientWidth(Window) - 4, ClientHeight(Window) - 24)
				
		' switch mode button
		FreeGadget(modebutton1)
		FreeGadget(modebutton2)
		FreeGadget(statbutton2)
		FreeGadget(screenbutton)
		modebutton1 = CreateButton("Compact Mode", width - 94, 4, 90, 20, canvas, BUTTON_PUSH)
		modebutton2 = CreateButton("Compact Mode", width - 94, 4, 90, 20, statistics, BUTTON_PUSH)
		screenbutton = CreateButton("Screenshot", width - 94, 24, 90, 20, statistics, BUTTON_PUSH)
		statbutton2 = CreateButton("Scan", width - 94, 44, 90, 20, statistics, BUTTON_PUSH)

		' show buttons
		ShowGadget statbutton1
		ShowGadget scanbutton
		ShowGadget blipbutton
		ShowGadget scoobutton
		ShowGadget warnbutton
		ShowGadget starbutton
		ShowGadget planbutton
		ShowGadget cashbutton
		ShowGadget precbutton
		ShowGadget hornbutton
		ShowGadget sam1button
		ShowGadget sam2button
		ShowGadget volume
		ShowGadget time
		ShowGadget progress

	EndIf

End Function

' ----------------------------------------------------------------------------
' updates the window position, scale, aspect and delta scale values
' ----------------------------------------------------------------------------
Function UpdateScale()

	cx = GadgetX(Window)
	cy = GadgetY(Window)
	cw = GadgetWidth(Window)
	ch = GadgetHeight(Window)
	as = cw * 1.0 / ch
	
	dx = cw * 1.0 / width
	dy = ch * 1.0 / Height
			
End Function

' ----------------------------------------------------------------------------
' updates the GUI
' ----------------------------------------------------------------------------
Function UpdateGUI()

	Local sx:Int
	Local sy:Int
		
	' draw image
	SetGraphics CanvasGraphics(canvas)
				
	Cls
	
	info.reset
	
	If modeflag = 1 Then
	
		' compact window
		SetColor(255, 255, 255)
		SetScale(1.0, 1.0)
		SetBlend(ALPHABLEND)
		SetAlpha(1.0)
		DrawImage image_compact, 0, 0
		sx = 8
		sy = 110
		info.Scale = 14
		SetScale(1.0, 1.0)

		SetAlpha(1.0)
		SetImageFont(fontsmall)
		
	Else
	
		' full window
		SetColor(255, 255, 255)
		SetScale(1.0, 1.0)
		SetBlend(ALPHABLEND)
		SetAlpha(1.0)
		DrawImage image, 0, 0
		sx = 10
		sy = 385
		info.Scale = 19
		SetScale(1.0, 1.0)
		
		' scan range border
		SetColor(0, 0, 0)
		DrawRect(width - 199, Height - 185, 191, 26)
	
	EndIf
	
	SetGraphics CanvasGraphics(canvas)
	
	If calflag And modeflag = 0 Then
	
		cal1.Create
		cal1.x = width - 390
		cal1.y = Height - 350
		cal1.w = 190
		cal1.h = 160			
		UpdateCalendar(cal1, canvas)
		
		cal2.Create
		cal2.x = width - 199
		cal2.y = Height - 350
		cal2.w = 190
		cal2.h = 160
		UpdateCalendar(cal2, canvas)
										
	EndIf
	
	SetAlpha(1.0)
	SetImageFont(font)
	
	Local d:Int = 14
		
	info.RGB = [0, 255, 0]
	info.shadow = True
	info.shadowoffset = 1
	info.offx = sx
	info.offy = sy
	info.upp = True
		
	If body Then
			
		info.add(FillSpaces("Name", d) + Left(body.name, 23))
		info.Add(FillSpaces("Distance", d) + FormatMath(body.distance, 0) + "ls = " + FormatMath(body.distance / 499.0) + "AU")
		info.Add(FillSpaces("Temperature", d) + FormatMath(body.temperature, 0) + "K = " + FormatMath(body.temperature - 273.3, 0) + "°C")
		info.Add(FillSpaces("Radius", d) + FormatINT(Int(body.radius / 1000.0)) + "km")
		
		If body.startype Then
		
			info.Add(FillSpaces("Class", d) + body.startype, 5)
			info.Add(FillSpaces("Mass", d) + FormatMath(body.starmass))
			info.Add(FillSpaces("Magnitude", d) + FormatMath(body.magnitude))
			info.Add(FillSpaces("Age", d) + FormatMath(body.age, 0) + " Mio. Years")
			
			Select body.startype
			
				Case "T", "Y", "L"
				
					info.Add(FillSpaces("Brown Dwarf. Not scoopable.", d), 5)

				Case "O", "B", "A", "F", "G", "K", "M"
				
					info.Add(FillSpaces("Main Sequence Star. Scoopable!", d), 5)
					
				Case "X"
				
					info.Add(FillSpaces("Exotic Star. Very rare. Not scoopable.", d), 5)
		
				Case "W", "WN", "WNC", "WC", "WO"
				
					info.Add(FillSpaces("Wolf-Rayet Star. Very rare. Not scoopable.", d), 5)

				Case "CS", "C", "CN", "CJ", "CH", "CHd"

					info.Add(FillSpaces("Carbon Star. Very rare. Not scoopable.", d), 5)
					
				Case "TTS", "AeBe"
				
					info.Add(FillSpaces("T-Tauri Star. Protostar. Not scoopable.", d), 5)
				
				Case "N"
				
					info.Add(FillSpaces("Neutron Star. Danger! Extreme Radiation!", d), 5)

				Case "H", "SupermassiveBlackHole"
				
					info.Add(FillSpaces("Black Hole. Danger! Extreme Gravity!", d), 5)
					
				Case "D", "DA", "DAB", "DAO", "DAZ", "DAV", "DB", "DBZ", "DBV", "DO", "DOV", "DQ", "DC", "DCV", "DX"
				
					info.Add(FillSpaces("White Dwarf. Danger! Extreme Gravity!", d), 5)

			End Select
			
			If Instr(body.startype, "SuperGiant") Then
			
				info.Add(FillSpaces("Super Giant Star. Danger!  Extreme Heat!", d), 5)
				
			Else If Instr(body.startype, "Giant") Then
			
				info.Add(FillSpaces("Giant Star. Danger! Extreme Heat!", d), 5)
				
			EndIf

		Else
		
			info.Add(FillSpaces("Class", d) + body.Class, 5)
			info.Add(FillSpaces("Mass", d) + FormatMath(body.planetmass, 3))
			info.Add(FillSpaces("Gravity", d) + FormatMath(body.gravity / 9.81, 3))
			info.Add(FillSpaces("Pressure", d) + FormatMath(body.pressure / 100000.0, 3))

			If body.terraflag Then
			
				info.Add(FillSpaces("Planet is Terraformable. Very precious!", d), 5)
				
			Else If body.Class = "Earthlike body" Then
			
				info.Add(FillSpaces("Planet is Earthlike. Very precious!", d), 5)

			Else If body.Class = "Water world" Then
			
				info.Add(FillSpaces("Planet is a Water World. Precious!", d), 5)
				
			Else If body.Class = "Ammonia world" Then
			
				info.Add(FillSpaces("Planet is an Ammonia World. Precious!", d), 5)

			Else If body.Class = "Metal rich body" Then
			
				info.Add(FillSpaces("Planet is Metal Rich. Precious!", d), 5)

			Else
			
				info.Add(FillSpaces("Planet is not precious.", d), 5)
			
			EndIf
			
		EndIf
		
	Else
	
		info.Add("Welcome CMDR " + cmdr)
		info.Add("Scan a planet first to view results.")
		info.Add(" ")
		info.Add("Time UTC   : " + FTimestamp(GetTimeStamp()))
		info.Add("Time Local : " + FTimestamp(GetTimeStampLocal()))
		info.Add("Correction : " + timecorrection)
	
	EndIf

	info.Update()
		
	SetBlend(SOLIDBLEND)
					
	Flip

End Function

' ----------------------------------------------------------------------------
' updates a calendar object
' ----------------------------------------------------------------------------
Function UpdateCalendar(cal:TCalendar, canvas:TGadget)
		
	SetBlend(ALPHABLEND)
	SetImageFont(font)
	
	Local h:Int = TextHeight("X") * 0.7
	Local w:Int = TextWidth("   ")
	
	' set origin to calender position on canvas
	SetOrigin(cal.x, cal.y)
	
	' background
	SetAlpha(cal.back[3] / 255.0)
	SetColor(cal.back[0], cal.back[1], cal.back[2])
	DrawRect(0, 0, cal.w - 0, cal.h - 1)
		
	' border
	SetAlpha(cal.border[3] / 255.0)
	SetColor(cal.border[0], cal.border[1], cal.border[2])
	DrawRect(1, 1, cal.w - 2, cal.h - 3)
	
	' header text
	SetAlpha(cal.color[3] / 255.0)
	SetColor(cal.color[0], cal.color[1], cal.color[2])
	DrawText months[cal.mm] + " " + cal.yy, 95 - (Len(months[cal.mm] + " " + cal.yy) * 8 / 2), 5
	DrawText "Mo Di Mi Do Fr Sa So", 15, h * 1.6
	DrawText " <<", 0, 5
	DrawText ">> ", cal.w - TextWidth(">> "), 5
	
	Local cnt:Int = 0
		
	' draw calendar days
	For Local t:Int = EachIn cal.caldays
	
		Local y:Int = Int(cnt / 7)
		Local x:Int = cnt - (y * 7)
				
		' days
		SetAlpha(cal.color[3] / 255.0 * 0.75)
		SetColor(cal.color[0], cal.color[1], cal.color[2])
		
		' current selected day
		If Int(t) = cal.dd And cnt >= cal.arrstart And cnt <= cal.arrend Then
		
			SetAlpha(cal.selected[3] / 255.0)
			SetColor(cal.selected[0], cal.selected[1], cal.selected[2])
			
		EndIf
					
		' output single day
		DrawText cal.FormatDay(t), x * w + 15, (y + 3) * h
		
		cnt:+1
		
	Next
	
	Local c:TClick

	' check for clicks and hovers
	For c = EachIn clicklist
				
		' canvas and calendar matches?
		If canvas = c.gadget And cal = c.cal Then
		
			c.Update()
			
			If c.clicked And Right(c.Key, 4) = "BACK" Then
			
				cal.mm:-1
				If cal.mm < 1 Then cal.mm = 12 ; cal.yy:-1
				c.clicked = 0
				'EmitEvent(CreateEvent(EVENT_MOUSEUP))
				
			EndIf
			
			If c.hover And (Right(c.Key, 4) = "BACK" Or Right(c.Key, 7) = "FORWARD") Then
			
				SetColor(cal.hover[0], cal.hover[1], cal.hover[2])
				SetAlpha(1.0)
				If Right(c.Key, 4) = "BACK" Then DrawText " <<", 0, 5
				If Right(c.Key, 7) = "FORWARD" Then DrawText ">> ", cal.w - TextWidth(">> "), 5

				SetAlpha(0.0)
				SetColor(cal.color[0], cal.color[1], cal.color[2])
			
			EndIf

			If c.clicked And Right(c.Key, 7) = "FORWARD" Then
			
				cal.mm:+1
				If cal.mm > 12 Then cal.mm = 1 ; cal.yy:+1
				c.clicked = 0
				'EmitEvent(CreateEvent(EVENT_MOUSEUP))
				
			EndIf
			
			Local px:Int
			Local py:Int
			
			If c.clicked Then
			
				Local day:Int
				
				If cal = cal1 And Left(c.Key = "CAL1_", 5) Then day = Int(Replace(c.Key, "CAL1_", ""))
				If cal = cal2 And Left(c.Key = "CAL2_", 5) Then day = Int(Replace(c.Key, "CAL2_", ""))
				
				Local d:Int = cal.caldays[day]
				Local m:Int = cal.mm
				Local y:Int = cal.yy
								
				If day < cal.arrstart Then m:-1 ; If m < 1 Then m = 12 ; y:-1
				If day > cal.arrend Then m:+1 ; If m > 12 Then m = 1 ; y:+1
				
				cal.dd = d
				cal.mm = m
				cal.yy = y
				
				c.clicked = 0
				c.hover = 0
				EmitEvent(CreateEvent(EVENT_MOUSEUP))
				
				Local date1:Int = cal1.GetUnixTimestamp(cal1.yy, cal1.mm, cal1.dd, 0, 0, 0)
				Local date2:Int = cal1.GetUnixTimestamp(cal2.yy, cal2.mm, cal2.dd, 0, 0, 0)
				
				If date1 > date2 Then
				
					datefrom = date2
					dateto = date1 + 86400
					
				Else
				
					datefrom = date1
					dateto = date2 + 86400
					
				EndIf
				
				'If cal = cal1 And Left(c.Key = "CAL1_", 5) Then Print "Calendar1: " + d + "." + m + "." + y
				'If cal = cal2 And Left(c.Key = "CAL2_", 5) Then Print "Calendar2: " + d + "." + m + "." + y
				
			EndIf
						
			If c.hover Then
			
				Local day:Int

				If cal = cal1 And Left(c.Key = "CAL1_", 5) Then day = Int(Replace(c.Key, "CAL1_", ""))
				If cal = cal2 And Left(c.Key = "CAL2_", 5) Then day = Int(Replace(c.Key, "CAL2_", ""))				
								
				py = Int(day / 7)
				px = day - (py * 7)
			
				If Left(c.Key = "CAL1_", 5) Then DrawText(cal.out, 15 + (px * 24), ((py + 3) * 16))
				If Left(c.Key = "CAL2_", 5) Then DrawText(cal.out, 15 + (px * 24), ((py + 3) * 16))
			
			EndIf

		EndIf
			
	Next
	
	SetOrigin(0, 0)
	
End Function

' ----------------------------------------------------------------------------
' updates the statistics
' ----------------------------------------------------------------------------
Function UpdateStatistics()

	SetGraphics CanvasGraphics(statistics)

	Cls
	
	SetBlend(ALPHABLEND)
	SetAlpha(1.0)
		
	If modeflag = 0 Then
	
		Local d:Int = 16
		
		SetBlend(ALPHABLEND)
		SetAlpha(0.5)
		SetColor(255, 255, 255)
		DrawImage image_stats, 0, 0
				
		SetBlend ALPHABLEND
		SetAlpha(1.0)

		SetImageFont(fontlarge)
		info.reset
		info.RGB = [0, 255, 0]
		info.shadow = True
		info.offx = 10
		info.offy = 0
		
		info.Add("CMDR " + cmdr)
		info.Update()
		
		SetImageFont(fontmid)
		info.reset
		
		info.RGB = [0, 224, 0]
		info.sha = [0, 0, 0]
		info.shadow = True
		info.shadowoffset = 1
		info.upp = True
		info.bar = False
		info.offy = 45
		info.lineoffset = Null
		info.Scale = 18
		
		' ----------------------------------------------------------------------------
		' General statistics
		' ----------------------------------------------------------------------------
		info.offx = 10
		info.Add(FillSpaces("Ship", d, ".") + ": " + shipname + " (" + ship + ")", 5)
		info.Add(FillSpaces("Credits", d, ".") + ": " + FormatINT(credits), 5)
		info.Update()
				
		' ----------------------------------------------------------------------------
		' Brown Dwarfs
		' ----------------------------------------------------------------------------

		SetImageFont(font)
		info.offx = 10
		info.offy = 110
		info.rgb = [208, 140, 56]
		info.Add("Brown Dwarfs", 5, "left", 255, 192, 64)
		info.Add("Star Class Y", 7)
		info.Add("Star Class T")
		info.Add("Star Class L")
		info.add("Star Class TTS")
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 290, info.offy + 30)
		
		info.offx = 200
		info.offy = 140
		info.Add(FormatINT(bodycount.classy), Null, "right")
		info.Add(FormatINT(bodycount.classt), Null, "right")
		info.Add(FormatINT(bodycount.classl), Null, "right")
		info.Add(FormatINT(bodycount.classtts), Null, "right")
		info.Update()

		info.offx = 300
		info.offy = 140
		info.Add(FormatINT(bodycount.mclassy), Null, "right")
		info.Add(FormatINT(bodycount.mclasst), Null, "right")
		info.Add(FormatINT(bodycount.mclassl), Null, "right")
		info.Add(FormatINT(bodycount.mclasstts), Null, "right")
		info.Update()

		' ----------------------------------------------------------------------------
		' Main Sequence Stars
		' ----------------------------------------------------------------------------

		info.offx = 10
		info.offy = 220
		info.rgb = [208, 208, 104]
		info.Add("Main sequence Stars", 5, "left", 255, 255, 128)
		info.Add("Star Class M", 7)
		info.Add("Star Class K")
		info.Add("Star Class G")
		info.Add("Star Class F")
		info.Add("Star Class A")
		info.Add("Star Class B")
		info.Add("Star Class O")
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 290, info.offy + 30)
		
		info.offx = 200
		info.offy = 250
		info.Add(FormatINT(bodycount.classm), Null, "right")
		info.Add(FormatINT(bodycount.classk), Null, "right")
		info.Add(FormatINT(bodycount.classg), Null, "right")
		info.Add(FormatINT(bodycount.classf), Null, "right")
		info.Add(FormatINT(bodycount.classa), Null, "right")
		info.Add(FormatINT(bodycount.classb), Null, "right")
		info.Add(FormatINT(bodycount.classo), Null, "right")
		info.Update()

		info.offx = 300
		info.offy = 250
		info.Add(FormatINT(bodycount.mclassm), Null, "right")
		info.Add(FormatINT(bodycount.mclassk), Null, "right")
		info.Add(FormatINT(bodycount.mclassg), Null, "right")
		info.Add(FormatINT(bodycount.mclassf), Null, "right")
		info.Add(FormatINT(bodycount.mclassa), Null, "right")
		info.Add(FormatINT(bodycount.mclassb), Null, "right")
		info.Add(FormatINT(bodycount.mclasso), Null, "right")
		info.Update()

		' ----------------------------------------------------------------------------
		' Special Stars
		' ----------------------------------------------------------------------------

		info.offx = 10
		info.offy = 385
		info.rgb = [104, 208, 104]
		info.Add("Special Stars", 5, "left", 128, 255, 128)
		info.Add("Giants", 7)
		info.Add("Super Giants")
		info.Add("Neutron Stars")
		info.Add("White Dwarfs")
		info.Add("Black Holes")
		info.Add("Carbon Stars")
		info.Add("Wolf-Rayet Stars")
		info.Add("Exotic Stars")
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 290, info.offy + 30)
		
		info.offx = 200
		info.offy = 420
		info.Add(FormatINT(bodycount.giant), Null, "right")
		info.Add(FormatINT(bodycount.supergiant), Null, "right")
		info.Add(FormatINT(bodycount.classn), Null, "right")
		info.Add(FormatINT(bodycount.classd), Null, "right")
		info.Add(FormatINT(bodycount.classh), Null, "right")
		info.Add(FormatINT(bodycount.classc), Null, "right")
		info.Add(FormatINT(bodycount.classw), Null, "right")
		info.Add(FormatINT(bodycount.classx), Null, "right")
		info.Update()

		info.offx = 300
		info.offy = 420
		info.Add(FormatINT(bodycount.mgiant), Null, "right")
		info.Add(FormatINT(bodycount.msupergiant), Null, "right")
		info.Add(FormatINT(bodycount.mclassn), Null, "right")
		info.Add(FormatINT(bodycount.mclassd), Null, "right")
		info.Add(FormatINT(bodycount.mclassh), Null, "right")
		info.Add(FormatINT(bodycount.mclassc), Null, "right")
		info.Add(FormatINT(bodycount.mclassw), Null, "right")
		info.Add(FormatINT(bodycount.mclassx), Null, "right")
		info.Update()

		' ----------------------------------------------------------------------------
		' Summation
		' ----------------------------------------------------------------------------

		info.offx = 330
		info.offy = 110
		info.rgb = [255, 255, 255]
		info.add("Rewards per Class", 5)
		info.add("Brown Dwarfs", 7, "left", 255, 192, 64)
		info.add("Main sequence Stars", Null, "left", 255, 255, 128)
		info.add("Special Stars", Null, "left", 128, 255, 128)
		info.add("Precious Planets", Null, "left", 128, 255, 255)
		info.add("Boulders", Null, "left", 64, 192, 255)
		info.Add("Gas Giants", Null, "left", 255, 160, 224)
		info.Add("Total", 10)
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 350, info.offy + 30)
		DrawLine(info.offx, info.offy + 30 + 118, info.offx + 350, info.offy + 30 + 118)

		info.offx = 570
		info.offy = 140
		info.add(FormatINT(bodycount.total1), Null, "right", 255, 192, 64)
		info.add(FormatINT(bodycount.total2), Null, "right", 255, 255, 128)
		info.add(FormatINT(bodycount.total3), Null, "right", 128, 255, 128)
		info.add(FormatINT(bodycount.total4), Null, "right", 128, 255, 255)
		info.add(FormatINT(bodycount.total5), Null, "right", 64, 192, 255)
		info.Add(FormatINT(bodycount.total6), Null, "right", 255, 160, 224)
		info.add(FormatINT(bodycount.total), 10, "right")
		info.Update()

		info.offx = 680
		info.offy = 140
		info.add(FormatINT(bodycount.mtotal1), Null, "right", 255, 192, 64)
		info.add(FormatINT(bodycount.mtotal2), Null, "right", 255, 255, 128)
		info.add(FormatINT(bodycount.mtotal3), Null, "right", 128, 255, 128)
		info.add(FormatINT(bodycount.mtotal4), Null, "right", 128, 255, 255)
		info.add(FormatINT(bodycount.mtotal5), Null, "right", 64, 192, 255)
		info.Add(FormatINT(bodycount.mtotal6), Null, "right", 255, 160, 224)
		info.add(FormatINT(bodycount.mtotal), 10, "right")
		info.Update()
				
		' ----------------------------------------------------------------------------
		' Precious Planets
		' ----------------------------------------------------------------------------

		info.offx = 330
		info.offy = 280
		info.rgb = [104, 208, 208]
		info.Add("Precious Planets", 5, "left", 128, 255, 255)
		info.Add("Earthlikes", 7)
		info.Add("Waterworlds")
		info.Add("Waterworlds (T)")
		info.Add("Ammoniaworlds")
		info.Add("Metal Rich")
		info.Add("High metal Content")
		info.Add("High metal Content (T)")
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 350, info.offy + 30)
		
		info.offx = 570
		info.offy = 310
		info.Add(FormatINT(bodycount.earth), Null, "right")
		info.Add(FormatINT(bodycount.water), Null, "right")
		info.Add(FormatINT(bodycount.waterterr), Null, "right")
		info.Add(FormatINT(bodycount.ammon), Null, "right")
		info.Add(FormatINT(bodycount.metal), Null, "right")
		info.Add(FormatINT(bodycount.hmc), Null, "right")
		info.Add(FormatINT(bodycount.hmcterr), Null, "right")
		info.Update()

		info.offx = 680
		info.offy = 310
		info.Add(FormatINT(bodycount.mearth), Null, "right")
		info.Add(FormatINT(bodycount.mwater), Null, "right")
		info.Add(FormatINT(bodycount.mwaterterr), Null, "right")
		info.Add(FormatINT(bodycount.mammon), Null, "right")
		info.Add(FormatINT(bodycount.mmetal), Null, "right")
		info.Add(FormatINT(bodycount.mhmc), Null, "right")
		info.Add(FormatINT(bodycount.mhmcterr), Null, "right")
		info.Update()

		' ----------------------------------------------------------------------------
		' Boulders
		' ----------------------------------------------------------------------------

		info.offx = 330
		info.offy = 442
		info.rgb = [48, 160, 224]
		info.Add("Boulders", 5, "left", 64, 192, 255)
		info.Add("Rocky", 7)
		info.Add("Rocky (T)")
		info.Add("Rocky Icy")
		info.Add("Icy")
		info.Add("Belt Clusters")
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 350, info.offy + 30)
		
		info.offx = 570
		info.offy = 472
		info.Add(FormatINT(bodycount.rocky), Null, "right")
		info.Add(FormatINT(bodycount.rockyterr), Null, "right")
		info.Add(FormatINT(bodycount.rockicy), Null, "right")
		info.Add(FormatINT(bodycount.icy), Null, "right")
		info.Add(FormatINT(bodycount.cluster), Null, "right")
		info.Update()

		info.offx = 680
		info.offy = 472
		info.Add(FormatINT(bodycount.mrocky), Null, "right")
		info.Add(FormatINT(bodycount.mrockyterr), Null, "right")
		info.Add(FormatINT(bodycount.mrockicy), Null, "right")
		info.Add(FormatINT(bodycount.micy), Null, "right")
		info.Add(FormatINT(bodycount.mcluster), Null, "right")
		info.Update()

		' ----------------------------------------------------------------------------
		' Gas Giants
		' ----------------------------------------------------------------------------

		info.offx = 710
		info.offy = 370
		info.rgb = [224, 128, 192]
		info.Add("Gas Giants", 5, "left", 255, 160, 224)
		info.Add("Class I Giants", 7)
		info.Add("Class II Giants")
		info.Add("Class III Giants")
		info.Add("Class IV Giants")
		info.Add("Class V Giants")
		info.Add("Gas Giant (Water)")
		info.Add("Gas Giant (Ammonia)")
		info.Add("Gas Giant (Helium)")
		info.Add("Water Giants")
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 300, info.offy + 30)
		
		info.offx = 910
		info.offy = 400
		info.Add(FormatINT(bodycount.gas1), Null, "right")
		info.Add(FormatINT(bodycount.gas2), Null, "right")
		info.Add(FormatINT(bodycount.gas3), Null, "right")
		info.Add(FormatINT(bodycount.gas4), Null, "right")
		info.Add(FormatINT(bodycount.gas5), Null, "right")
		info.Add(FormatINT(bodycount.gaswater), Null, "right")
		info.Add(FormatINT(bodycount.gasammon), Null, "right")
		info.Add(FormatINT(bodycount.gashelium), Null, "right")
		info.Add(FormatINT(bodycount.watergiant), Null, "right")
		info.Update()

		info.offx = 1010
		info.offy = 400
		info.Add(FormatINT(bodycount.mgas1), Null, "right")
		info.Add(FormatINT(bodycount.mgas2), Null, "right")
		info.Add(FormatINT(bodycount.mgas3), Null, "right")
		info.Add(FormatINT(bodycount.mgas4), Null, "right")
		info.Add(FormatINT(bodycount.mgas5), Null, "right")
		info.Add(FormatINT(bodycount.mgaswater), Null, "right")
		info.Add(FormatINT(bodycount.mgasammon), Null, "right")
		info.Add(FormatINT(bodycount.mgashelium), Null, "right")
		info.Add(FormatINT(bodycount.mwatergiant), Null, "right")
		info.Update()
		
		' ----------------------------------------------------------------------------
		' Summation (graphic)
		' ----------------------------------------------------------------------------

		SetBlend(ALPHABLEND)
		info.offx = 710
		info.offy = 110
		info.Scale = 18
				
		For Local i:Int = 1 To 6
		
			Local c:Int = 0
			If i = 1 Then c = bodycount.total1 ; SetColor(255, 192, 64)
			If i = 2 Then c = bodycount.total2 ; SetColor(255, 255, 128)
			If i = 3 Then c = bodycount.total3 ; SetColor(128, 255, 128)
			If i = 4 Then c = bodycount.total4 ; SetColor(128, 255, 255)
			If i = 5 Then c = bodycount.total5 ; SetColor(64, 192, 255)
			If i = 6 Then c = bodycount.total6 ; SetColor(255, 160, 224)
		
			SetAlpha(0.75)
			DrawRect(info.offx + 170, info.offy + (i * info.Scale) + 20, 130, info.Scale * 0.9)

			If bodycount.total Then
			
				SetAlpha(0.5)
				SetColor(0, 0, 0)
				
				Local l:Float = (1 - (c * 1.0 / bodycount.total))
				
				DrawRect(info.offx + 170, info.offy + (i * info.Scale) + 20, 125 * l, info.Scale * 0.9)
				
			EndIf
			
		Next
		
		'Print bodycount.mtotal1
		'Print bodycount.mtotal2
		'Print bodycount.mtotal3
		'Print bodycount.mtotal4
		'Print bodycount.mtotal5
		'Print bodycount.mtotal6
		
		'Print bodycount.mtotal
		
		For Local i:Int = 1 To 6
		
			Local c:Long = 0
			If i = 1 Then c = bodycount.mtotal1 ; SetColor(255, 192, 64)
			If i = 2 Then c = bodycount.mtotal2 ; SetColor(255, 255, 128)
			If i = 3 Then c = bodycount.mtotal3 ; SetColor(128, 255, 128)
			If i = 4 Then c = bodycount.mtotal4 ; SetColor(128, 255, 255)
			If i = 5 Then c = bodycount.mtotal5 ; SetColor(64, 192, 255)
			If i = 6 Then c = bodycount.mtotal6 ; SetColor(255, 160, 224)
		
			SetAlpha(0.75)
			DrawRect(info.offx + 170, info.offy + ((i + 6) * info.Scale) + 20 + 5, 130, info.Scale * 0.9)

			If bodycount.total Then
			
				SetAlpha(0.5)
				SetColor(0, 0, 0)
				
				Local l:Float = (1 - (c * 1.0 / bodycount.mtotal))
				
				DrawRect(info.offx + 170, info.offy + ((i + 6) * info.Scale) + 20 + 5, 125 * l, info.Scale * 0.9)
				
			EndIf
			
		Next		
		
		info.rgb = [255, 255, 255]
		info.Add("Scans and Rewards (total)", 5)
		info.add("Brown Dwarfs", 7, "left", 255, 192, 64)
		info.add("Main sequence Stars", Null, "left", 255, 255, 128)
		info.add("Special Stars", Null, "left", 128, 255, 128)
		info.add("Precious Planets", Null, "left", 128, 255, 255)
		info.add("Boulders", Null, "left", 64, 192, 255)
		info.Add("Gas Giants", Null, "left", 255, 160, 224)
		info.add("Brown Dwarfs", 5, "left", 255, 192, 64)
		info.add("Main sequence Stars", Null, "left", 255, 255, 128)
		info.add("Special Stars", Null, "left", 128, 255, 128)
		info.add("Precious Planets", Null, "left", 128, 255, 255)
		info.add("Boulders", Null, "left", 64, 192, 255)
		info.Add("Gas Giants", Null, "left", 255, 160, 224)
		info.Update()
		SetColor(255, 255, 255)
		DrawLine(info.offx, info.offy + 30, info.offx + 300, info.offy + 30)
		
		Flip
		
	Else

		SetBlend(ALPHABLEND)
		SetAlpha(0.6)
		SetColor(255, 255, 255)
		DrawImage image_stats_compact, 0, 0
					
		info.reset
		info.rgb = [0, 255, 0]
		info.shadow = True
		info.offx = width / 2
		info.offy = Height / 2 - TextHeight("X")
		
		If modeflag = 1 Then
		
			' compact window
			SetAlpha(1.0)
			SetImageFont(fontsmall)
			
		Else
		
			' full window
			SetAlpha(1.0)
			SetImageFont(Font)
		
		EndIf
		
		SetBlend ALPHABLEND
		SetAlpha(1.0)
		
		SetImageFont(fontmid)
		info.reset
		info.RGB = [0, 255, 0]
		info.shadow = True
		info.offx = 10
		info.offy = 5
		
		info.Add("CMDR " + cmdr)
		info.Update()
		
		SetImageFont(fontsmall)
		info.reset
		
		info.RGB = [0, 192, 0]
		info.sha = [0, 0, 0]
		info.shadow = True
		info.shadowoffset = 1
		info.upp = True
		info.bar = False
		info.offy = 32
		info.lineoffset = Null
		info.Scale = 18
		
		' ----------------------------------------------------------------------------
		' General statistics
		' ----------------------------------------------------------------------------
		info.offx = 10
		info.Add(FillSpaces("Ship", 10, ".") + ": " + shipname + " (" + ship + ")", 5)
		info.Add(FillSpaces("Credits", 10, ".") + ": " + FormatINT(credits), 0)
		info.Update()

		' ----------------------------------------------------------------------------
		' Summation
		' ----------------------------------------------------------------------------

		info.offx = 10
		info.offy = 80
		info.rgb = [255, 255, 255]
		info.Add("Rewards per Class", 5)
		info.add("Brown Dwarfs", 7, "left", 255, 192, 64)
		info.add("Main sequence Stars", Null, "left", 255, 255, 128)
		info.add("Special Stars", Null, "left", 128, 255, 128)
		info.add("Precious Planets", Null, "left", 128, 255, 255)
		info.add("Boulders", Null, "left", 64, 192, 255)
		info.Add("Gas Giants", Null, "left", 255, 160, 224)
		info.add("Total", 10)
		info.Update()
		DrawLine(info.offx, info.offy + 30, info.offx + 360, info.offy + 30)
		DrawLine(info.offx, info.offy + 30 + 115, info.offx + 360, info.offy + 30 + 115)

		info.offx = 250
		info.offy = 110
		info.add(FormatINT(bodycount.total1), Null, "right", 255, 192, 64)
		info.add(FormatINT(bodycount.total2), Null, "right", 255, 255, 128)
		info.add(FormatINT(bodycount.total3), Null, "right", 128, 255, 128)
		info.add(FormatINT(bodycount.total4), Null, "right", 128, 255, 255)
		info.add(FormatINT(bodycount.total5), Null, "right", 64, 192, 255)
		info.Add(FormatINT(bodycount.total6), Null, "right", 255, 160, 224)
		info.add(FormatINT(bodycount.total), 10, "right")
		info.Update()

		info.offx = 370
		info.offy = 110
		info.add(FormatINT(bodycount.mtotal1), Null, "right", 255, 192, 64)
		info.add(FormatINT(bodycount.mtotal2), Null, "right", 255, 255, 128)
		info.add(FormatINT(bodycount.mtotal3), Null, "right", 128, 255, 128)
		info.add(FormatINT(bodycount.mtotal4), Null, "right", 128, 255, 255)
		info.add(FormatINT(bodycount.mtotal5), Null, "right", 64, 192, 255)
		info.Add(FormatINT(bodycount.mtotal6), Null, "right", 255, 160, 224)
		info.add(FormatINT(bodycount.mtotal), 10, "right")
		info.Update()
		
		Flip
				
	EndIf

End Function

' ----------------------------------------------------------------------------
' creates a Screenshot
' ----------------------------------------------------------------------------
Function Screenshot()

	EmitEvent(CreateEvent(EVENT_GADGETACTION, tabs, 1, 0, 0, 0, tab[1]))
	RedrawGadget(statistics)
	
	Delay 100

	Local filename:String = RequestFile("Select Screenshot filename...", "PNG Files:png", True, "CMDR " + cmdr)
									
	If filename Then
	
		If (SavePixmapPNG(GrabPixmap(0, 0, width, Height), filename, 0)) Then
		
			LogUpdate("Screenshot saved to " + filename, True)
			Notify("Screenshot saved to " + filename)
			
		Else
		
			LogUpdate("ERROR: Screenshot " + filename + " could not be saved.")
			Notify("ERROR: Screenshot " + filename + " could not be saved.")
			
		EndIf
	
	EndIf

End Function

' ----------------------------------------------------------------------------
' updates the statistics
' ----------------------------------------------------------------------------
Function UpdateAnalysis()

	SetGraphics CanvasGraphics(analysis)
		
	Cls

	SetBlend(ALPHABLEND)
	SetAlpha(1.0)
			
	If modeflag = 0 Then
	
		'Local d:Int = 16
		
		SetBlend(ALPHABLEND)
		SetAlpha(0.5)
		SetColor(255, 255, 255)
		DrawImage image_stats, 0, 0
				
		SetBlend ALPHABLEND
		SetAlpha(1.0)

		SetImageFont(fontlarge)
		info.reset
		info.RGB = [0, 255, 0]
		info.shadow = True
		info.offx = 10
		info.offy = 0
		info.Add("Analysis")
		info.Update()
		
		SetImageFont(font)

		' ----------------------------------------------------------------------------
		' Terraformable Bodies per Star
		' ----------------------------------------------------------------------------
		info.reset
		info.offx = 10
		info.offy = 50
		info.add("Terraformable per Star", 0, "left", 255, 255, 255)
		info.RGB = [0, 255, 0]
		For Local a:TAnalysis = EachIn analysislist
		
			If a.cat = "TerraStar" Then info.Add(FillSpaces(a.Key, 16, ".") + ": " + a.val)
		
		Next
		info.Update()

		' ----------------------------------------------------------------------------
		' Earthlikes per Star
		' ----------------------------------------------------------------------------
		info.reset
		info.offx = 10
		info.offy = 50 + (11 * 15)			
		info.add("Earthlikes per Star", 0, "left", 255, 255, 255)
		info.RGB = [0, 255, 0]
		For Local a:TAnalysis = EachIn analysislist
		
			If a.cat = "EarthStar" Then info.Add(FillSpaces(a.Key, 16, ".") + ": " + a.val)
		
		Next
		info.Update()

		' ----------------------------------------------------------------------------
		' Water worlds per Star
		' ----------------------------------------------------------------------------
		info.reset
		info.offx = 10
		info.offy = 50 + (23 * 15)
		info.add("Water worlds per Star", 0, "left", 255, 255, 255)
		info.RGB = [0, 255, 0]
		For Local a:TAnalysis = EachIn analysislist
		
			If a.cat = "WaterStar" Then info.Add(FillSpaces(a.Key, 16, ".") + ": " + a.val)
		
		Next
		info.Update()

		' ----------------------------------------------------------------------------
		' Star Classes (Parents)
		' ----------------------------------------------------------------------------
		info.reset
		info.offx = 220
		info.offy = 50
		info.add("Star Classes (Parents)", 0, "left", 255, 255, 255)
		info.RGB = [0, 255, 0]
		For Local a:TAnalysis = EachIn analysislist
		
			If a.cat = "StarType" Then info.Add(FillSpaces(a.Key, 26, ".") + ": " + a.val)
		
		Next
		info.Update()
					
	Else
	
		SetBlend(ALPHABLEND)
		SetAlpha(0.6)
		SetColor(255, 255, 255)
		DrawImage image_stats_compact, 0, 0
											
		info.reset
		info.rgb = [0, 255, 0]
		info.shadow = True
		info.offx = width / 2
		info.offy = Height / 2 - TextHeight("X")
		
		If modeflag = 1 Then
		
			' compact window
			SetAlpha(1.0)
			SetImageFont(fontsmall)
			
		Else
		
			' full window
			SetAlpha(1.0)
			SetImageFont(Font)
		
		EndIf
		
		SetBlend ALPHABLEND
		SetAlpha(1.0)
		
		SetImageFont(fontmid)
		info.reset
		info.RGB = [0, 255, 0]
		info.shadow = True
		info.offx = 10
		info.offy = 5
		
		info.Add("Analysis")
		info.Update()
		
	EndIf
		
	Flip
		
End Function